# Cocobot — $COCO

**Agent + blockchain**, inspired by OpenClaw: workspace with identity, soul, and instructions, plus on-chain skills (EVM/Base, tokens).

## What it is

- **Cocobot ($COCO):** An agent with an OpenClaw-style workspace (`IDENTITY.md`, `SOUL.md`, `AGENTS.md`, skills) that can run blockchain actions.
- **Skills:** Wallet balance (native + ERC-20), send ETH, check any ERC-20 balance.
- **ERC-20:** Optional. Set `COCO_TOKEN_ADDRESS` in `.env` to show that token in `/balance` and `cocobot balance`.

## Requirements

- Node ≥20
- A wallet private key (only for sending; balance checks work with a public RPC)

## Install and run (no clone)

```bash
npx cocobot agent
```

This runs the agent loop. You can also use:

```bash
npx cocobot balance
npx cocobot send <address> <amount>
npx cocobot token <tokenAddress> [account]
```

If you cloned the repo instead:

```bash
npm install
cp .env.example .env
# Edit .env: COCO_RPC_URL, COCO_WALLET_PRIVATE_KEY, optional COCO_TOKEN_ADDRESS
npx cocobot agent
```

## Usage

- **Agent loop:** `npx cocobot agent` — then use `/balance`, `/send <addr> <amount>`, `/token <addr>`, `/quit`.
- **Quick balance:** `npx cocobot balance`
- **Send ETH:** `npx cocobot send 0x... 0.01`
- **ERC-20 balance:** `npx cocobot token 0xTokenAddress`

## Workspace (OpenClaw-style)

- `workspace/IDENTITY.md` — agent name, vibe, emoji
- `workspace/SOUL.md` — persona and tone
- `workspace/AGENTS.md` — instructions and tool usage
- `workspace/USER.md` — user preferences
- `workspace/TOOLS.md` — available tools
- `workspace/skills/wallet/SKILL.md` — wallet skill
- `workspace/memory/` — daily logs (optional)

## Blockchain

- Default chain: **Base** (`https://mainnet.base.org`). Change `COCO_RPC_URL` for another network.
- Wallet: `COCO_WALLET_PRIVATE_KEY` (hex, with or without `0x`).
- Optional token: set `COCO_TOKEN_ADDRESS` to any ERC-20 on the same chain to see its balance in `balance` and in the agent.

## Landing (web chat + download)

A landing page lets people chat with Cocobot (using your `OPENAI_API_KEY` on the server) and download or run the bot on their PC with `npx cocobot agent` (no key needed locally).

**Local:**

```bash
npm run pack   # optional: build zip for "Download Cocobot"
npm run landing
```

Open `http://localhost:3000`. The page shows the mascot (`coco.png`), a chat (OpenAI), and instructions to run `npx cocobot agent` or download the zip.

**Deploy to Vercel:** See [Deploy to Vercel](#deploy-to-vercel) below.

## Deploy to Vercel

1. Push the repo to GitHub and import the project in [Vercel](https://vercel.com).
2. Set environment variable **OPENAI_API_KEY** in the Vercel project (Settings → Environment Variables).
3. Deploy. The build runs `npm run pack` and copies `cocobot.zip` to the output; the landing and `/api/chat` are served automatically.

The root `index.html` is the landing; `/api/chat` is a serverless function. Static assets: `/coco.png`, `/cocobot.zip` (built at deploy time).

## Publish to npm

So others can run `npx cocobot agent` without cloning:

1. **Create an npm account** (if you don’t have one): [npmjs.com/signup](https://www.npmjs.com/signup).

2. **Enable 2FA (required to publish):** npm requires two-factor authentication to publish. In [npmjs.com](https://www.npmjs.com) go to **Account → Security** and enable **Two-Factor Authentication** (auth-only or auth-and-writes). When you run `npm publish`, npm will prompt for the one-time code. Alternatively you can use a [granular access token](https://docs.npmjs.com/creating-and-viewing-access-tokens#creating-granular-access-tokens) with **Publish packages** and **Bypass 2FA** enabled, then run `npm publish` with that token (e.g. set `NPM_TOKEN` and use it).

3. **Log in from the project folder:**
   ```bash
   npm login
   ```
   Enter your npm username, password, and (if 2FA is on) the one-time code from your app.

4. **Check the package name:** The name in `package.json` is `cocobot`. If it’s already taken on npm, use a scoped name (e.g. `@tu-usuario/cocobot`) and update the `"name"` field.

5. **Publish:**
   ```bash
   npm publish
   ```
   The `prepublishOnly` script runs `npm run build` first, so `dist/` is built before publishing. Only `dist/` and `workspace/` are included (see the `files` field in `package.json`).

   If you use a **scoped** package (e.g. `@user/cocobot`), publish with public access:
   ```bash
   npm publish --access public
   ```

6. **Later updates:** Bump `version` in `package.json` (e.g. `0.1.1`), then run `npm publish` again.

## Build

```bash
npm run build
node dist/cli.js agent
```

## License

MIT
