import "dotenv/config";

const RPC_URL = process.env.COCO_RPC_URL || "https://mainnet.base.org";
const PRIVATE_KEY = process.env.COCO_WALLET_PRIVATE_KEY;
const COCO_TOKEN_ADDRESS = process.env.COCO_TOKEN_ADDRESS as `0x${string}` | undefined;

export const config = {
  rpcUrl: RPC_URL,
  privateKey: PRIVATE_KEY ? (PRIVATE_KEY.startsWith("0x") ? PRIVATE_KEY as `0x${string}` : `0x${PRIVATE_KEY}`) as `0x${string}` : undefined,
  cocoTokenAddress: COCO_TOKEN_ADDRESS,
  workspacePath: "workspace",
} as const;

export function hasWallet(): boolean {
  return !!config.privateKey;
}
