# Skill: wallet

Blockchain wallet operations for Cocobot.

## Actions

- **balance** — Get native and optional $COCO (ERC-20) balance for the configured wallet. Uses `COCO_RPC_URL` and `COCO_WALLET_PRIVATE_KEY`.
- **send** — Send native token to an address. Params: `to` (address), `amount` (in ETH or wei string), optional `chainId`.
- **tokenBalance** — Get ERC-20 balance for a token contract and address. Params: `tokenAddress`, `accountAddress` (default: configured wallet).

## Env

- `COCO_RPC_URL` — RPC endpoint (e.g. Base mainnet).
- `COCO_WALLET_PRIVATE_KEY` — Hex private key (no 0x prefix ok).
- `COCO_TOKEN_ADDRESS` — Optional ERC-20 contract address for balance/symbol.

## Safety

Never log or expose the private key. Use read-only RPC for balance checks when possible.
